function [fitresult, gof] = createFits_bin(x, y)
%CREATEFIT1(X,Y)
%  Create a fit.
%
%  Data for 'untitled fit 1' fit:
%      X Input : x
%      Y Output: y
%  Output:
%      fitresult : a fit object representing the fit.
%      gof : structure with goodness-of fit info.
%
%  另请参阅 FIT, CFIT, SFIT.

%  由 MATLAB 于 09-Jun-2022 20:45:31 自动生成


%% Fit: 'untitled fit 1'.
[xData, yData] = prepareCurveData( x, y );

% Set up fittype and options.
ft = fittype( 'a+b./(1+exp(-d*(x-c)))', 'independent', 'x', 'dependent', 'y' );
opts = fitoptions( 'Method', 'NonlinearLeastSquares' );
opts.Display = 'Off';
b=max(y);
c=median(x);
d=1;
a=min(y);
opts.StartPoint = [a b c d];

% Fit model to data.
[fitresult, gof] = fit( xData, yData, ft, opts );

% Plot fit with data.
% figure( 'Name', 'Psychmetric Curve' );
hold on

plot(xData, yData,'k.','MarkerSize',20,'Color',[0 0 0]);
h=plot( fitresult,'k');
h.LineWidth=2;
% legend( {'Data','Fitted Curve'}, 'Location', 'northwest', 'Interpreter', 'none','AutoUpdate','off');
legend off
% Label axes
xlabel( 'Stimulus Contrast (%)', 'Interpreter', 'none' );
ylabel( 'Aware Percent (%)', 'Interpreter', 'none' );
ylim([0 105])
R2=gof.rsquare;
text(13,15,strcat('R^2=',sprintf('%.2f',R2)),'FontSize',18);
hold off
box off
ax=gca;
ax.FontSize=18;
ax.LineWidth=1.5;
yticks(0:25:100)
yticklabels(0:25:100)
% grid on


